/*
	SPRITEFACTORY system Script.  Release 11. Rewrote interface, new functions are not backwards compatible. Added Cache

		Changes from 10: Added ApplyColorFXPerson() which is like ColorMatrixPerson (but the name is not so cool) from my game 
		Changes from 9b: Made more functions return this, so you can chain commands. fixed typeof bug.
		Changes from Beta 8: Minor Cleanups suggested by Flik
		Changes from Beta 7: Incorporated SetPersonSpriteset()
		Changes from Beta 6: Fixedbug, added Brian's .save
		Changes from Beta 5: close rawfile, exists(), undermix(), a little faster

 Usage example:
	EvaluateScript("spritefactory.js");  //To be replaced by EvaluateSystemScript("spritesets.js");
	var mixsprite = new SpriteFactory();
	CreatePerson('hero', "nudebody.rss", false); // Poor hero is nude.

	mixsprite.SetSpritebase("nudebody.rss"); // or: mixsprite.SetSpritebase( GetPersonSpriteset("hero") ); 
	var colormatrix = CreateColorMatrix(0,  0, 0, 255,    0,  0, 255, 0,    0,  255, 0, 0); 
	mixsprite.overMix("newclothes.rss", colormatrix); // "newclothes.rss" is loaded automatically into the cache
	mixsprite.overMix("newshoes.rss");
	SetPersonSpriteset('hero',mixsprite.GetSpritebase()); //Ahh.. finally clothed!
	
	if( mixsprite.saveAs("newsprite.rss"))
		Abort("Saved new spriteset successfully");
	else 
		Abort("Could not save new spriteset (file already exists?)");
	


Get/Set Spriteset from/to cache

GetSpriteset()
        Returns the spriteset reference from the SpriteFactory object
        You can also adress spritebase and cache directly.
        examples:
                var spritesetBase = mixsprite.GetSpriteset();
                var spritesetBase = mixsprite.spritebase; //same as line above
                var spritesetClone= mixsprite.spritebase.clone(); //same as line above, but changes to spritesetClone wont change mixsprite.spritebase
                var spriteset = mixsprite.LoadSpriteset("hair.rss"); //Will load the rss only once, and return a cached version afterwards.
                var spriteset = mixsprite.LoadSpriteset("hair.rss").clone(); //Will load the rss only once, and return a cloned cached version afterwards.
                var spriteset = mixsprite.LoadSpriteset("hair.rss",false); //same as: var spriteset =LoadSpriteset("hair.rss"); Not cached.
                var spriteset = mixsprite.GetSpriteset("hair.rss"); //Get a cached rss, if cached using: mixsprite.LoadSpriteset("hair.rss",true);
                var spriteset = mixsprite.CACHE("hair.rss"); //same as line above
                var spriteset = mixsprite.CACHE("hair.rss").clone(); //same as line above, but changes to spriteset wont affect the cache

Get/Set Spritebase, all our mixing is done using the spritebase

	Remember that Sphere only has GetPersonBase, and cannot set the Personbase, so spritesetBase defines the Base,
	while overMix() overmixes new images, but keeps the base intact. So always start with a good base.

SetSpriteset(<SpriteSetName>,<SpriteSet>)
        Sets the given spriteset into the SpriteFactory object.
        But you can also adress spritebase and spritebasename directly.
        example:
                var spriteset = LoadSpriteset("chara.rss");
                mixsprite.SetSpriteset("chara.rss", spriteset);
                mixsprite.SetSpriteset("newname.rss", undefined); 
                mixsprite.SetSpriteset( GetPersonSpriteset("hero") );


*/



/* ----------------------------------------------------------------------
SpriteFactory([RSSfile] [,SpriteSetObject])
	Create a new SpriteFactory object.
	If SpriteSetObject is not given, it will load RSSfile, if defined.
	example:
		var mixsprite  = new SpriteFactory("body.rss");
		var mixsprite2 = new SpriteFactory("",GetSpriteSet(GetInputPerson()));

		var mixsprite  = new SpriteFactory();
		mixsprite.LoadSpriteset("helmet.rss"); //loads into cache
		mixsprite.LoadSpriteset("body.rss"); //loads into cache
		mixsprite.LoadSpriteset("armour.rss"); //loads into cache
		mixsprite.SetSpriteset("body.rss"); //Sets spritebase and spritebasename from rss in cache
*/
function SpriteFactory(spritebasename,spritebase)
{
  if (this instanceof SpriteFactory == false) 
    return new SpriteFactory(spritebasename,spritebase);

  this.error=false;
  this.cached=true;
  this.CACHE=Object();
  this.LoadSpriteset=function(rss,cached){return cached==false?  LoadSpriteset(rss): this.CACHE[rss]||(this.CACHE[rss]=LoadSpriteset(rss));}
  this.GetSpriteset=function(rss) {return rss? this.CACHE[rss]:this.spritebase;}
  this.SetSpriteset=function(rss,spriteset) {this.CACHE[rss||spriteset.filename]=spriteset; return this;}
  this.GetSpritebase=function() {return this.spritebase;} //TODO: check,do we need clone() here?
  this.SetSpritebase=function(rss,cached){
    if(typeof rss == 'string'){
      this.spritebase = this.LoadSpriteset(rss,cached).clone();
      this.spritebasename = rss;
      return this;
    }else{
      this.spritebase = rss.clone();
      this.spritebasename = rss.filename || '_'; 
      if(cached != false){
      	this.CACHE[this.spritebasename] = rss.clone();
      }
      return this;
    }
  }
  this.spritebasename = spritebasename;
  if(spritebase)
    this.spritebase   = spritebase;
  else if(this.spritebasename)
    this.spritebase   = this.LoadSpriteset(spritebasename);

  this.transparant=CreateColor(0,0,0, 0);
}

SpriteFactory.prototype.success=function(){return !this.error;}
SpriteFactory.prototype.reset=function(){this.error=false;return this;}
SpriteFactory.prototype.clearCache=function(){this.CACHE=new Object();return this;}

/* ----------------------------------------------------------------------
applyColorMatrix(mixcolormatrix)
	Applies a color matrix over the entire spritebase
	example:
		var mixsprite  = new SpriteFactory();
		mixsprite.SetSpritebase("body.rss");
		mixcolormatrix= CreateColorMatrix(0, 85,85,85,  0, 85,85,85,  0, 85,85,85);
		var newSprite = mixsprite.applyColorMatrix(mixcolormatrix) //The function returns the new rss
		var newSprite = mixsprite.spritebase; //The spritebase now contains the new rss (same as above)
		mixsprite.SetSpriteset("newbody.rss", newSprite); //Store new rss into cache

	or, in less lines:
		var mixsprite  = new SpriteFactory();
		mixsprite.SetSpritebase("body.rss").applyColorMatrix(CreateColorMatrix(0, 85,85,85,  0, 85,85,85,  0, 85,85,85)).SetSpriteset("newbody.rss", newSprite);
*/
SpriteFactory.prototype.applyColorMatrix = function(mixcolormatrix) {
  var tsi=this.spritebase.images;
  var i=tsi.length-1;
  do {
   	var surf1= tsi[i].createSurface();
	surf1.applyColorFX(0, 0, surf1.width, surf1.height,  mixcolormatrix);
	tsi[i] = surf1.createImage();
  }
  while(i--);
  return this;
}

/**
 * cleantransparencies(mixcolormatrix). Got Broken in new Sphere releases. Have not been able to fix it.
 * Clean Transparencies is useful when you have done lots of overmixing. Then the sprite will have
 * multicolored transparencies, this will sweep over them and making them one colour.
 * You can define this default transparant colour.

 * example:
 *   var mixsprite  = new SpriteFactory();
 *   mixsprite.transparant = CreateColor(255,255,0, 0);
 *   // do things here with the spritebase...
 *   mixsprite.cleantransparencies();
*/
SpriteFactory.prototype.cleantransparencies_broken= function(cleancolor) {
return; //Broken. CreateImage will not clean alpha=0 colors. I tried it in 3 different ways and failed... :(
  var transparant=cleancolor||this.transparant;
  var almost_transparant = transparant.clone(); almost_transparant.alpha = 1;
  var opaque = CreateColor(transparant.red, transparant.green, transparant.blue, 255);
  var tsi=this.spritebase.images;
  i=tsi.length-1;
  do {
        var surf1= tsi[i].createSurface();
	surf1.setBlendMode(BLEND);
	var surf2 = CreateSurface(surf1.width, surf1.height, opaque);
	surf2.blitSurface(surf1, 0,0);
	surf2.replaceColor(opaque,transparant)
        tsi[i] = surf2.createImage(); // Create image garbles transparent colors :(
  }
  while(i--);
  return this;
}

// The only other way to clean transparencies is to edit the spriteset file directly... :(
SpriteFactory.prototype.cleantransparencies = function(cleancolor, filename) {
	var transparant=cleancolor||this.transparant;
	if (!filename) return this.cleantransparencies_broken();
	var rawfile = OpenRawFile("../spritesets/"+filename);
	var raw = CreateByteArray(0);
	var data;
	while( (data = rawfile.read(20480)) && (data.length>0)){ raw = raw.concat(data); }
	rawfile.close();

	if( raw[4] != 3 ) Abort("Trying to clean a SpriteSet which is not version 3");
	var max_images = (raw[7]<<8) + raw[6];
	var width = (raw[9]<<8) + raw[8];
	var height = (raw[11]<<8) + raw[10];
	var totalpixels = max_images * width * height;
	/*
	// This does the same as do while()...
	for (var pixel = 0 ; pixel < totalpixels; ++pixel){
		data = 128 + pixel*4;
		if(!raw[data+3]){
			raw[data]  =transparant.red;
			raw[data+1]=transparant.green;
			raw[data+2]=transparant.blue;
		}
	}
	*/
	var pixel = totalpixels - 1;
	do{
		data = 128 + pixel*4;
		if(raw[data+3]) continue;
		raw[data]  =transparant.red;
		raw[data+1]=transparant.green;
		raw[data+2]=transparant.blue;
	}while(pixel--);

	// Now write it back:
	rawfile = OpenRawFile("../spritesets/"+filename, true);
	rawfile.write(raw);
	rawfile.close();
}

/**
 * Tells you if a spriteset file already exists.
 * @param {string} rssfile The filename of the rss file
 * @returns true if the file already exists, false if not
 * @type Boolean
 *
 * Example:
 *   if ( mixsprite.exists("newsprite.rss") )
 *   {
 *     //Do something (like asking to confirm overwriting this file)
 *   }
 *
 * note: If you need to know if this spriteset is cached, use this:
 *   if( mixsprite.CACHED["newsprite.rss"] ) {
 *     //Do something
 *   } 
 */
SpriteFactory.prototype.exists = function(rssfile) {
		var FileName = rssfile||this.spritebasename;
		var FileList = GetFileList("spritesets");
		var i = FileList.length-1;
		do
 			if (FileName == FileList[i]) return true;
		while(i--);
		return false;
}


/* ----------------------------------------------------------------------
saveAs([RSSfile] [,overwrite],[cleantransparencies])
	It saves the SpriteFactory object to the file <RSSfile>.
	if <RSSfile> is undefined, it will use the object's spritebasename.
	If [overwrite] is not given or is false, it will fail if the
	file already exists. The default is to NOT overwrite, use true 
	to overwrite.
	example:
		if ( mixsprite.saveAs("newsprite.rss",true) ) 
			print("File saved successfully");
		else 
			print("error: File newsprite.rss already existed.");

		if ( mixsprite.saveAs() ) 
			print("File saved successfully");
		else 
			print("error: File "+mixsprite.spritebasename+"already existed.");
*/
SpriteFactory.prototype.saveAs = function(savenamerss,overwrite,cleantransparencies) {
  var FileName=savenamerss||this.spritebasename;
  if(!overwrite && this.exists(FileName)) return false;
  return this.save(FileName,cleantransparencies);
}


/* ----------------------------------------------------------------------
save([RSSfile],[cleantransparencies])
	It saves the SpriteFactory object to the file [RSSfile].
	if [RSSfile] is undefined, it will use the object's spritebasename.
	No checks are done whatsoever. (i.e. it always overwrites)
	example:
		mixsprite.save("newsprite.rss");
		mixsprite.save(mixsprite.spritebasename); //The same as: mixsprite.save();

	Clean Transparencies is when you have done lots of overmixing, the sprite will have
	multicolored transparencies, this will sweep over them and making them one colour.
*/
SpriteFactory.prototype.save = function(savenamerss,cleantransparencies) {
	var FileName=savenamerss||this.spritebasename;
	var result = this.spritebase.save(FileName);
	if(cleantransparencies)this.cleantransparencies(undefined, FileName);
	return result;
}


/* ----------------------------------------------------------------------
underMix(<RSSfile|SpriteSetObject>,[ColorMatrix],[fixtransparencies])
	Does the same as overMix, but <RSSfile|SpriteSetObject> is blended UNDER your spriteset.
	dont use [fixtransparencies], you wont notice it and it is slower.
	example:
		var colormatrix = CreateColorMatrix(0, 0,0,255,   0, 0,255,0,  0, 255,0,0);
		mixsprite.underMix("newclothes.rss", colormatrix);
		var rss = GetPersonSpriteset( GetInputPerson() );
		var newrss = mixsprite.underMix(rss);
*/
SpriteFactory.prototype.underMix = function(mixrss, mixcolormatrix,fixtransparencies) {
	var spr1 = this.spritebase;
	this.spritebase= (typeof mixrss == "string")? this.LoadSpriteset(mixrss).clone(): mixrss;
	if(mixcolormatrix) this.applyColorMatrix(mixcolormatrix);
	return this.mix(spr1,undefined,fixtransparencies);
}


/* ----------------------------------------------------------------------
overMix(<RSSfile|SpriteSetObject>,[ColorMatrix],[fixtransparencies])
	If [ColorMatrix] is given, it is applied to <RSSfile|SpriteSetObject> 
	(the file on disk does not change),
	And then it overlaps the current sprite using <RSSfile|SpriteSetObject>.
	if fixtransparencies==true then overMix reserves tranparency 
	value of 1 for true transparency. (So you can overlap a small 
	helmet over a bunch of hair, and still get rid of the hair. slower)
	example:
		var colormatrix = CreateColorMatrix(0, 0,0,255,  0, 0,255,0,  0, 255,0,0);
		mixsprite.overMix("newclothes.rss", colormatrix);
		mixsprite.overMix("newshoes.rss");
		mixsprite.overMix("newhelmet.rss", undefined, true);
		var newhelmet = LoadSpriteset("myhelmet.rss");
		mixsprite.overMix(newhelmet, undefined, true);
*/
SpriteFactory.prototype.overMix = function(mixrss, mixcolormatrix, fixtransparencies) {
	var spr2 = (typeof mixrss == "string")? this.LoadSpriteset(mixrss): mixrss;
	return this.mix(spr2,mixcolormatrix,fixtransparencies);
}


/* ----------------------------------------------------------------------
mix(<SpriteSet>,[ColorMatrix],[fixtransparencies])
	Does the same as overMix, but instead of a *.rss file, you give it a SpriteSet.
	example:
		var sprite = LoadSpriteset("mysprite.rss");
		mixsprite.mix(sprite);
		mixsprite.mix(sprite, colormatrix);
*/
SpriteFactory.prototype.mix = function(spr2, mixcolormatrix,fixtransparencies) {
  var tsi=this.spritebase.images;
	var ReFrame= new Array(tsi.length); // Remember which frames we've already done
	var tsd=this.spritebase.directions;
	var tsdl=tsd.length;
	for(var i1=0; i1<tsdl;++i1)
	{
  		var i2 = 0;
		var sdl=spr2.directions.length;
  		while ( 	(i2 < sdl) &&
				!(spr2.directions[i2].name == tsd[i1].name) ) 
		++i2;	//Search spr2's same direction
		if(i2>=sdl) continue; //mixrss doesnt have this direction
		var sdi2=spr2.directions[i2];
		if(sdi2.frames.length>=tsd[i1].frames.length)
  		{
			var j=tsd[i1].frames.length-1;
			do
			{
				var tsdi1fji=tsd[i1].frames[j].index;
				if(ReFrame[tsdi1fji]==1) continue;
				ReFrame[tsdi1fji]=1; //Mark as done
				var surf1= tsi[tsdi1fji].createSurface();
				var surf2= spr2.images[sdi2.frames[j].index].createSurface();

				if(typeof mixcolormatrix=="object")
					surf2.applyColorFX(0, 0, surf2.width, surf2.height,  mixcolormatrix);
				surf1.blitSurface(surf2, 0, 0);

				if(fixtransparencies){
					var transparant=CreateColor(0,0,0, 0);	//Almost transparent. (helmet stuff)
					surf1.setBlendMode(REPLACE);
					var y=surf1.height-1;
					do{var x=surf1.width-1;
					do{var color= surf2.getPixel(x, y);
					if(color.alpha == 1)
						surf1.setPixel(x,y,transparant);
					}while(x--);}while(y--);
				}
				tsi[tsdi1fji]=surf1.createImage();
			}
			while(j--);
  		}
  		else
			this.error=true;
	}
	return this;
}



//======================= EXAMPLES ===============================================================//


/* ----------------------------------------------------------------------
	When swapping two spritesets, you have to be careful to replace
	the current spriteset with one that has the same directions as
	the one being used. Swaps the SpriteSet of the GetInputPerson()

function SwapWith(rss,sprite)
{
	//rss = rss.replace(/.rss$/, "");  //Remove .rss at the end.
	SetPersonSpriteset(sprite||GetInputPerson(), mixsprite.LoadSpriteset(rss) );
}


 ----------------------------------------------------------------------
	Saves the current Input person's spriteset.

function Save(filename,sprite)
{
	GetPersonSpriteset( sprite||GetInputPerson() ).save(filename);
}


 ----------------------------------------------------------------------
	To mix the main character with the garment:
	First we Created globally declared SpriteFactory Objects. You must take
	care that the used spritefactory has all the directions	the current Input 
	Person has. Logically, we use the current Input Person.
	Then we get and use the current spriteset
	(which can have modifications) so we can overlap multiple things. 
	We mix and save. If successful, we swap the Input Person with the 
	rss we just created. 

function MixAndSave(garb,colormatrix,fixtransparencies,sprite)
{

	var mixsprite = new SpriteFactory(); 

	var rss = GetPersonSpriteset( sprite||GetInputPerson() );
	mixsprite.SetSpritebase(rss);

	//Now we overmix 1 thing. But we can call overMix() multiple times,
	//and save the endresult once.
	mixsprite.overMix(garb, colormatrix,fixtransparencies);


	if ( mixsprite.saveAs("newsprite.rss",true,fixtransparencies) )
		SwapWith("newsprite.rss");
}

 ----------------------------------------------------------------------
        Like MixAndSave, but mixes it UNDER the spriteset.

function UnderMixAndSave(garb,colormatrix,sprite)
{
        var mixsprite = new SpriteFactory();
        mixsprite.SetSpritebase( GetPersonSpriteset( GetInputPerson()||sprite ) );
        mixsprite.underMix(garb, colormatrix);
        if ( mixsprite.saveAs("newsprite.rss",true) )
                SwapWith("newsprite.rss",sprite);
}


 ----------------------------------------------------------------------
	Applies a color matrix over the entire spriteset, saves and
	loads it as the spriteset of the current InputPerson

function EnColorMatrixChar(colormatrix,sprite)
{
	var mixsprite = new SpriteFactory(); 
	mixsprite.SetSpritebase( GetPersonSpriteset( sprite||GetInputPerson() ) );
	mixsprite.applyColorMatrix(colormatrix);
	if ( mixsprite.saveAs("newsprite.rss",true,true) )
		SwapWith("newsprite.rss",sprite);
}

 ----------------------------------------------------------------------
	Applies a color matrix over the entire spriteset on-the-fly
	(no harddisk involved)
*/
function ApplyColorFXPerson(colormatrix,sprite) {
	var mixsprite = new SpriteFactory('',GetPersonSpriteset(sprite||GetInputPerson())); 
	mixsprite.applyColorMatrix(colormatrix);
	SetPersonSpriteset(sprite,mixsprite.spritebase);
}

/* ----------------------------------------------------------------------
	Like overMix, but mixes it UNDER the spriteset.
*/
function UnderMixAndSave(garb,colormatrix,sprite)
{
	var mixsprite = new SpriteFactory(); 
	mixsprite.SetSpritebase( GetPersonSpriteset( GetInputPerson()||sprite ) );
	mixsprite.underMix(garb, colormatrix);
	if ( mixsprite.saveAs("newsprite.rss",true) )
		SwapWith("newsprite.rss",sprite);
}

/* ----------------------------------------------------------------------
	This is like MixAndSave, but it doesnt load and save the spriteset,
	It uses the current inputperson as source and destiny.
*/
function MixAndSwap(garb,colormatrix,fixtransparencies,sprite)
{
	var mixsprite = new SpriteFactory("",GetPersonSpriteset( sprite||GetInputPerson() ));
	mixsprite.overMix(garb, colormatrix,fixtransparencies);
	SetPersonSpriteset( sprite||GetInputPerson(),mixsprite.GetSpriteset() );
}

/*
	If you create only one SpriteFactory object at the beginning of the game, you can reuse it:

	var mixsprite = new SpriteFactory();
	mixsprite.MixAndSwap = function(garb,colormatrix,fixtransparencies,sprite){
		this.spritebase = GetPersonSpriteset( sprite||GetInputPerson() );
		this.overMix(garb, colormatrix,fixtransparencies);
		SetPersonSpriteset( sprite||GetInputPerson(),mixsprite.GetSpritebase() );
	}
	

*/

/* ---------------------------------------------------------------------- */


// ====================================================================== //

/**
 * Modify CreateColorMatrix() so we can read its values. (not reall)
 * use .update() to re-create a CM:
 *   var cm = CreateColorMatrix(0, 0,0,255,  0, 0,255,0,  0, 255,0,0);
 *   cm.rn=255; // modify the basic color red, but the colormatrix will not change.
 *   cm = cm.update(); // Update the native ColorMatrix using the modified values
 *   ColorArray = cm.getColorArray(); // We can actually save this ColorArray
 *   cm2 = CreateColorMatrix.apply(null, ColorArray); // Transfer the colors into another colormatrix
 */
if(typeof CreateColorMatrix_== 'undefined'){
	CreateColorMatrix_ = CreateColorMatrix;
	CreateColorMatrix = function(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb){
		var o = CreateColorMatrix_(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb);
		o.rn=rn; o.rr=rr; o.rg=rg; o.rb=rb;
		o.gn=gn; o.gr=gr; o.gg=gg; o.gb=gb;
		o.bn=bn; o.br=br; o.bg=bg; o.bb=bb;
		o.update = function(){
			return CreateColorMatrix(this.rn, this.rr, this.rg, this.rb,  this.gn, this.gr, this.gg, this.gb,  this.bn, this.br, this.bg, this.bb);
		};
		o.getColorArray = function(){
			return [this.rn, this.rr, this.rg, this.rb,  this.gn, this.gr, this.gg, this.gb,  this.bn, this.br, this.bg, this.bb];
		}
		o.toJSON = function(){
		}
		return o;
	};
};

/**
 * Used to change the color of an item's icon/picture.
 * We cannot easily ItemStore() a CreateColorMatrix object, so define it like a JS object, 
 * use .create() to create a CM:
 *   var cm= new ColorMatrix_JS(1,2,3,4, 5,6,7,8, 9,10,11,12);
 *   cm.rn=255;
 *   ColorMatrix= cm.create();
 */
function ColorMatrix_JS(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb){
	if(this instanceof ColorMatrix_JS==false) {
		return new ColorMatrix_JS(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb);
	}

	this.rn=rn; this.rr=rr; this.rg=rg; this.rb=rb;
	this.gn=gn; this.gr=gr; this.gg=gg; this.gb=gb;
	this.bn=bn; this.br=br; this.bg=bg; this.bb=bb;

	this.cm = CreateColorMatrix(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb);

	this.update = function(){
		this.cm = CreateColorMatrix(this.rn, this.rr, this.rg, this.rb,  this.gn, this.gr, this.gg, this.gb,  this.bn, this.br, this.bg, this.bb);
	};

	this.create = function(){
		this.update();
		return this.cm;
	};
}

